// $Id: CClosestDivisionPanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CClosestDivisionPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CClosestDivisionPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CClosestDivisionPanel, CControlPanel);

//	===========================================================================
CClosestDivisionPanel::CClosestDivisionPanel(IControlRoot *root, const long uniqueId, const CRect &area)
                     : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
					 , m_closestRateBpmEditBox(NULL)
					 , m_closestRateFreqEditBox(NULL)
					 , m_closestRateOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CClosestDivisionPanel);

	this->onDrawDrawThePanelBounds(false);

	// BPM edit
	m_closestRateBpmEditBox		  = new CTextEdit(this,  e_closestRateBpmEditBox,		    CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "120.00", this);
	m_closestRateFreqEditBox	  = new CTextEdit(this,  e_closestRateFreqEditBox,		    CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "2.00",   this);
	m_closestRateOutputValueLabel = new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_closestRateBpmEditBox->referenced();
	m_closestRateFreqEditBox->referenced();
	m_closestRateOutputValueLabel->referenced();

	// Set the format
	m_closestRateBpmEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_closestRateFreqEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_closestRateOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_closestRateBpmEditBox->setAlignment(CTextEdit::e_center);
	m_closestRateFreqEditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_closestRateBpmEditBox->setSingleClickEditable();
	m_closestRateFreqEditBox->setSingleClickEditable();

	// Colours
	m_closestRateBpmEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_closestRateFreqEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_closestRateOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add controls
	this->addControl(m_closestRateBpmEditBox);
	this->addControl(m_closestRateFreqEditBox);
	this->addControl(m_closestRateOutputValueLabel);

	// Compute
	this->computeClosestDivision();
}

//	===========================================================================
CClosestDivisionPanel::~CClosestDivisionPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CClosestDivisionPanel);
			
	FORGET_COUNTED_OBJECT(m_closestRateBpmEditBox);
	FORGET_COUNTED_OBJECT(m_closestRateFreqEditBox);		
	FORGET_COUNTED_OBJECT(m_closestRateOutputValueLabel);				
}

//	===========================================================================
void CClosestDivisionPanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_closestRateBpmEditBox:
		case e_closestRateFreqEditBox:
			this->computeClosestDivision();
		break;
	}
}

//	===========================================================================
void CClosestDivisionPanel::computeClosestDivision()
{
	double bpm = CString::toDouble(m_closestRateBpmEditBox->getString().getString());
	
	if (bpm <= 0.0 || bpm >= 1000.0)
	{
		CDialog::notifyUser("Bpm range error!\n\n0.0 < bpm < 1000.0\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm = 120.0;
		m_closestRateBpmEditBox->setText("120.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm);
		m_closestRateBpmEditBox->setText(string);
	}
	m_closestRateBpmEditBox->update();

	double frequency = CString::toDouble(m_closestRateFreqEditBox->getString().getString());

	if (frequency <= 0.0 || frequency >= 13000)
	{
		CDialog::notifyUser("Frequency range error!\n\n0.0 < bpm < 13000.0\n\nBpm must be between 0 and 13000 Hz", "SCal error", true);
		frequency = 440.0;
		m_closestRateFreqEditBox->setText("440.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", frequency);
		m_closestRateFreqEditBox->setText(string);
	}
	m_closestRateFreqEditBox->update();

	CString output;
	CMusicMath::getADivisionString(output, CMusicMath::getClosestTempoDivisionToRateInHertz(bpm, frequency));
	m_closestRateOutputValueLabel->setText(output);
	m_closestRateOutputValueLabel->update();
}